/* _WGetstr function */
#include <string.h>
#include "xwstdio.h"
_STD_BEGIN

static int ranmatch(const wchar_t *su, wchar_t uc, size_t n)
	{	/* look for c in [] with ranges */
	while (3 <= n)
		if (su[1] == L'-')
			if (su[0] <= uc && uc <= su[2])
				return (1);
			else
				su += 3, n -= 3;
		else if (su[0] == uc)
			return (1);
		else
			++su, --n;
	for (; 0 < n; ++su, --n)
		if (su[0] == uc)
			return (1);
	return (0);
	}

int _WGetstr(_WSft *px, int sfl)
	{	/* convert %[] (sfl < 0), %c (sfl == 0), else %s */
	char buf[MB_LEN_MAX], *s;
	char range = 0;
	char seen = 0;
	int n, nset;
	int wfl = px->qual == L'l';
	wchar_t comp, *p;
	const wchar_t *t;
	wint_t ch;
	_Mbstinit(mbst);

	if (sfl < 0)
		{	/* parse [] in format */
		comp = (wchar_t)(*++px->s == L'^' ? *px->s++ : L'\0');
		t = wcschr(*px->s == L']'
			? px->s + 1 : px->s, L']');
		if (t == 0)
			return (0);
		nset = t - px->s;
		if (3 <= nset && wmemchr(px->s + 1, L'-', nset - 2))
			range = 1;
		}
	px->nget = 0 < px->width ? px->width :
		sfl != 0 ? INT_MAX : 1;
	if (px->noconv)
		;
	else if (wfl)
		p = va_arg(px->ap, wchar_t *);
	else
		s = va_arg(px->ap, char *);
	for (; (ch = WGETN(px)) != WEOF; seen = 1)
		if (0 < sfl && iswspace(ch) || sfl < 0
			&& (!range && (!comp && !wmemchr(px->s, ch, nset)
					|| comp && wmemchr(px->s, ch, nset))
				|| range && (!comp && !ranmatch(px->s, ch, nset)
					|| comp && ranmatch(px->s, ch, nset))))
			break;
		else if (px->noconv)
			;
		else if (wfl)
			*p++ = ch, px->stored = 1;
		else if ((n = _Wctomb(s, ch, &mbst)) < 0)
			return (0);
		else if (0 < n)
			s += n, px->stored = 1;
	if (wfl)
		;
	else if ((n = _Wctomb(buf, L'\0', &mbst)) <= 0)
		return (0);
	else
		memcpy(s, buf, n - 1);
	WUNGETN(px, ch);
	if (sfl == 0)
		return (seen ? 1 : EOF);
	if (!seen)
		return (ch == WEOF ? EOF : 0);
	if (px->noconv)
		;
	else if (wfl)
		*p = L'\0';
	else
		*s = '\0';
	if (sfl < 0)
		px->s = t;
	return (1);
	}
_STD_END

/*
 * Copyright (c) 1992-2003 by P.J. Plauger.  ALL RIGHTS RESERVED.
 * Consult your license regarding permissions and restrictions.
V4.02:1422 */
